% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mv_into_mat}
\alias{mv_into_mat}
\title{MIDAS variable matrix transformation}
\usage{
mv_into_mat(x, mv, K, type)
}
\arguments{
\item{x}{Variable according to which the MIDAS term has to be aligned. It must be an 'xts' object.}

\item{mv}{MIDAS variable, observed each period \eqn{t}. It must be an 'xts' object.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{type}{The frequency of the period of observations for the MIDAS variable. It can be 'weekly', 'monthly', 'quarterly' or 'yearly'.}
}
\value{
The resulting matrix has as many rows as the number of lagged realizations (plus one) of the MIDAS variable
to consider, and as many columns as the length of \eqn{x}.
}
\description{
Implements the transformation of the MIDAS variable into a matrix, whose dimension is
\eqn{(K+1) \times N}, where \eqn{K} is the number of lagged realizations to consider and
\eqn{N} is the length of the variable \eqn{x}.
}
\examples{
\donttest{
require(xts)
# weekly frequency
# obtain weekly MIDAS variable after daily aggregation
RV_weekly_sum<-apply.weekly(rv5^0.5,sum) #realized volatility
# then allocate correctly the information
RV_weekly<-as.xts(coredata(RV_weekly_sum),seq(as.Date("2000-01-10"), 
by = "week", length.out = length(RV_weekly_sum)))
# use mv_into_mat 
mv_into_mat(sp500['2002/2003-12-26'],diff(RV_weekly['/2003-12']),K=4,type="weekly")

# monthly frequency
r_t<-sp500['2005/2010']
mv_into_mat(r_t,diff(indpro),K=12,type="monthly")

# quarterly frequency
RV_quarterly_sum<-apply.quarterly(rv5,sum)
RV_quarterly<-as.xts(coredata(RV_quarterly_sum),seq(as.Date("2000-04-01"), 
by = "quarter", length.out = length(RV_quarterly_sum)))
mv_into_mat(sp500['2004/2010'],diff(RV_quarterly),K=10,type="quarterly")

# yearly frequency
RV_yearly_sum<-apply.yearly(rv5,sum)
RV_yearly<-as.xts(coredata(RV_yearly_sum),seq(as.Date("2001-01-01"), 
by = "year", length.out = length(RV_yearly_sum)))
mv_into_mat(sp500['2006/2010'],diff(RV_yearly),K=2,type="yearly")
}
}
