% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MB_Server.R
\name{MB_fetch_state}
\alias{MB_fetch_state}
\title{Fetch Model Builder State}
\usage{
MB_fetch_state(
  id,
  id_ASM,
  input,
  session,
  FM_yaml_file,
  MOD_yaml_file,
  react_state
)
}
\arguments{
\item{id}{Shiny module ID}

\item{id_ASM}{ID string for the app state management module used to save and load app states}

\item{input}{Shiny input variable}

\item{session}{Shiny session variable}

\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{react_state}{Variable passed to server to allow reaction outside of module (\code{NULL})}
}
\value{
list containing the current state of the app including default
values from the yaml file as well as any changes made by the user. The list
has the following structure:
\itemize{
\item{yaml:} Full contents of the supplied yaml file.
\item{MC:} Module components of the yaml file.
\item{MB:}
\itemize{
\item{isgood:} Boolean object indicating if the file was successfully loaded.
\item{checksum:} This is an MD5 sum of the contents element and can be
used to detect changes in the state.
}
\item{MOD_TYPE:} Character data containing the type of module \code{"MB"}
\item{id:} Character data containing the module id module in the session variable.
\item{FM_yaml_file:} App configuration file with FM as main section.
\item{MOD_yaml_file:}  Module configuration file with MC as main section.
}
}
\description{
Merges default app options with the changes made in the UI
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = MB_test_mksession()
session = sess_res$session
input   = sess_res$input

# Configuration files
FM_yaml_file  = system.file(package = "formods", "templates", "formods.yaml")
MOD_yaml_file = system.file(package = "ruminate", "templates", "MB.yaml")

# Creating an empty state object
state = MB_fetch_state(id              = "MB",
                       id_ASM          = "ASM",
                       input           = input,
                       session         = session,
                       FM_yaml_file    = FM_yaml_file,
                       MOD_yaml_file   = MOD_yaml_file,
                       react_state     = NULL)
}
