% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWT_PO.R
\name{FWT_PO}
\alias{FWT_PO}
\title{Forward Wavelet Transform (periodized, orthogonal)}
\usage{
FWT_PO(x, L, qmf)
}
\arguments{
\item{x}{1-d signal; length(x) = 2^J.}

\item{L}{Coarsest Level of V_0;  L << J.}

\item{qmf}{quadrature mirror filter (orthonormal).}
}
\value{
\code{wc} 1-d wavelet transform of x.
}
\description{
1. \code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
2. usually, \code{length(qmf) < 2^(L+1)}.
3. To reconstruct use \code{\link{IWT_PO}}.
}
\examples{
x <- MakeSignal('Ramp', 8)
L <- 0
qmf <- MakeONFilter('Haar')
wc <- FWT_PO(x, L, qmf)
}
\seealso{
\code{\link{IWT_PO}}, \code{\link{MakeONFilter}}.
}
