% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapPolys.R
\name{mapPolys}
\alias{mapPolys}
\title{Map polygon data.}
\usage{
mapPolys(
  mapToPlot = "",
  nameColumnToPlot = "",
  numCats = 7,
  xlim = NA,
  ylim = NA,
  mapRegion = "world",
  catMethod = "quantiles",
  colourPalette = "heat",
  addLegend = TRUE,
  borderCol = "grey",
  mapTitle = "columnName",
  oceanCol = NA,
  aspect = 1,
  missingCountryCol = NA,
  add = FALSE,
  lwd = 0.5
)
}
\arguments{
\item{mapToPlot}{a spatial polygons dataframe (e.g. from joinData2Map())
containing polygons and associated data, if none specified an internal
example data is used}

\item{nameColumnToPlot}{name of column containing the data you want to plot}

\item{numCats}{number of categories to put the data in, may be modified if
this number is incompatible with the catMethod chosen}

\item{xlim}{map extents c(west,east), can be overidden by mapRegion}

\item{ylim}{map extents c(south,north), can be overidden by mapRegion}

\item{mapRegion}{a country name from getMap()[['NAME']] or
'world','africa','oceania','eurasia','uk' sets map extents, overrides
xlim,ylim}

\item{catMethod}{for categorisation of data "pretty", "fixedWidth",
"diverging", "logFixedWidth", "quantiles", "categorical", or a numeric
vector defining breaks}

\item{colourPalette}{string describing the colour palette to use, choice of:
\enumerate{ \item "palette" for the current palette \item a vector of valid
colours, e.g. =c('red','white','blue') or output from RColourBrewer \item one
of "heat", "diverging", "white2Black", "black2White", "topo", "rainbow",
"terrain", "negpos8", "negpos9" }}

\item{addLegend}{whether to add a legend or not}

\item{borderCol}{the colour for country borders}

\item{mapTitle}{title to add to the map, any string or 'columnName' to set
it to the name of the data column}

\item{oceanCol}{a colour for the ocean}

\item{aspect}{aspect for the map, defaults to 1, if set to 'variable' uses
same method as plot.Spatial in sp}

\item{missingCountryCol}{a colour for missing countries}

\item{add}{whether to add this map on top of an existing map, TRUE/FALSE}

\item{lwd}{line width for country borders}
}
\value{
invisibly returns a list containing the data and main options used
for the map, the list can be passed to \code{\link{addMapLegend}} or
\code{\link{addMapLegendBoxes}} along with additional options to allow
greater flexibility in legend creation.
}
\description{
Plot a map of polygons, from a spatialPolygonsDataFrame, coloured according
to one a specified attribute column.
}
\details{
Certain catMethod and colourPalette options go well together. e.g.
"diverging" and "diverging", "categorical" and "rainbow"

There are two styles of legend available.  If catMethod='categorical' or the
packages fields and spam are not installed a simple legend with coloured
boxes is created. Otherwise a colour bar legend is created. Finer control
can be achieved by \code{\link{addMapLegendBoxes}} or
\code{\link{addMapLegend}} repectively.
}
\examples{


## this example uses downloaded files
## to run it download the files
## and remove the comment symbols '#' from all the lines starting with a single '#'

## US states map downloaded from :
## http://www2.census.gov/cgi-bin/shapefiles2009/national-files

#inFile <- 'tl_2009_us_stateec.shp'
#sPDF <- readShapePoly(inFile)
#str(sPDF@data)

##################
## use mapPolys to map the sPDF
#mapPolys(sPDF,nameColumnToPlot = "ALANDEC")
#mapPolys(sPDF,nameColumnToPlot = "AWATEREC",mapRegion='North America')

##################
## join some other data to it
## education data downloaded from here as xls then saved as csv
## http://nces.ed.gov/ccd/drpcompstatelvl.asp

#dataFile <- 'SDR071A_xls.csv'
#dF <- read.csv(dataFile,as.is=TRUE)
#str(dF)
## STATENAME
## DRP912 Dropout Rate, Grades 9 through 12

## joining the data to the map
## based upon state names (column NAMEEC in map, and STATENAME in the data)
#sPDF2 <- joinData2Map(dF
#        , nameMap = sPDF
#        , nameJoinIDMap = "NAMEEC"
#        , nameJoinColumnData = "STATENAME")

#################
## plot one of the attribute variables
#mapDevice()# to set nice shape map window
#mapPolys(sPDF2,nameColumnToPlot = "DRP912",mapRegion='North America')


#################
###to map US counties data (Tiger) downloaded from :
##http://www2.census.gov/cgi-bin/shapefiles2009/national-files

#inFile <- 'tl_2009_us_county.shp'
#sPDF <- readShapePoly(inFile)
#str(sPDF@data)
#mapPolys(sPDF,nameColumnToPlot='AWATER',xlim=c(-140,-65), ylim=c(25,45))



}
\seealso{
joinData2Map, classInt, RColorBrewer
}
\author{
andy south
}
\keyword{aplot}
