% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_setup.R
\name{smtl_setup}
\alias{smtl_setup}
\title{smtl_setup: setup Julia path and/or install Julia or Julia packages using functions based on external package JuliaCall::julia_setup().}
\usage{
smtl_setup(path = NULL, installJulia = FALSE, installPackages = FALSE)
}
\arguments{
\item{path}{A string}

\item{installJulia}{A boolean.}

\item{installPackages}{A boolean.}
}
\value{
A message indicating either Julia language or package installation status or the path of Julia Binary on your computer. See vignette if you have problems
specifying the path of Julia binary correctly.
}
\description{
smtl_setup: setup Julia path and/or install Julia or Julia packages using functions based on external package JuliaCall::julia_setup().
}
\examples{

\dontrun{

if (identical(Sys.getenv("AUTO_JULIA_INSTALL"), "true")) { ## The examples are quite time consuming
## Do initiation for and automatic installation if necessary
##################################################################
# First Time Loading, Julia is Installed and Julia Path is Known 
##################################################################
smtl_setup(path = "/Applications/Julia-1.5.app/Contents/Resources/julia/bin", 
           installJulia = FALSE, 
           installPackages = FALSE)

#####################################################################################
# If you have run smtl_setup() before, then path specification shouldn't be necessary
#####################################################################################
smtl_setup(path = NULL, installJulia = FALSE, installPackages = FALSE)

#####################################################################################
##### First Time Loading, Julia is Not Installed   ######
#####################################################################################
smtl_setup(path = NULL, installJulia = TRUE, installPackages = FALSE)

#####################################################################################
##### First Time Loading, Julia is Installed But Packages NEED INSTALLATION  ######
#####################################################################################
smtl_setup(path = "/Applications/Julia-1.5.app/Contents/Resources/julia/bin", 
           installJulia = TRUE, 
           installPackages = TRUE)
           
           }
           
 }
           
}
