% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDAtable.R
\name{GetDAtable}
\alias{GetDAtable}
\title{Genetic effects analysis of miRNA: |d/a| (method 1)}
\usage{
GetDAtable(P1_RPM, P2_RPM, F1_RPM, rpm_threshold = 1)
}
\arguments{
\item{P1_RPM}{A dataframe. The rpm data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the rpm of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the P2 species.}

\item{F1_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the F1 species.}

\item{rpm_threshold}{A numeric. the average of rpm value among all the biological replicates. By default, the average of rpm more than or equal to 1 is retained.}
}
\value{
A dataframe. The output results contain the value of "|d/a|" and grouping results for each miRNA expressed in all species (average_rpm >= rpm_threshold).
}
\description{
The additive (a) and dominant (d) values were calculated by the expression level of each miRNA. Edwards et al. proposed that the "|d/a|" can be used as the criterion to estimate the expression patterns of miRNAs. Specific classification criteria are as follows, |d/a| <= 0.2, additivity; |d/a| > 0.2 and |d/a| <= 0.8, partial dominance; |d/a| > 0.8 and |d/a| <= 1.2, dominance; |d/a| > 1.2, overdominance.
}
\examples{
##Get the classification results based on the value of |d/a|
DAresult <- GetDAtable(P1_RPM = P1_miRNA_rpm,
                       P2_RPM = P2_miRNA_rpm,
                       F1_RPM = F1_miRNA_rpm,rpm_threshold = 1)
}
