% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_data.R
\name{srdp_groups}
\alias{srdp_groups}
\title{Access to SRDP group-level data.}
\usage{
srdp_groups(wide = FALSE)
}
\arguments{
\item{wide}{Logical. When FALSE (default), provides a dataframe with one observation for every group-year dyad. When TRUE, provides a dataframe with one observation for every group.}
}
\value{
A tibble, with each group's kgcid, name, country, start year, end year, country challenged
}
\description{
This function provides a dataset of all SRDP groups, the countries they are
challenging, and their start and end dates. It covers the period between 1960
and 2005. You can use this function to access a long dataframe (one observation for each
group-year dyad), or a wide dataframe (one observation for each
group, with their start and end years provided in specific columns).
}
\details{
Please note, if a group started before 1960, its start year is listed as
\emph{NA}. If a group ended after 2005, its end year is listed as \emph{NA}.
}
\examples{
groups <- srdp_groups(wide = TRUE)
}
