% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avgPseudo.R
\name{avgPseudo}
\alias{avgPseudo}
\title{Small Area Estimation using Averaging Pseudo Area Level Model}
\usage{
avgPseudo(prov, reg, sub, vill, y, x, var, N, method = "REML")
}
\arguments{
\item{prov}{Vector containing information of province}

\item{reg}{Vector containing information of region}

\item{sub}{Vector containing information of subdistrict}

\item{vill}{Vector containing information of village}

\item{y}{Direct estimation for each area}

\item{x}{Auxiliary variable for each area}

\item{var}{Sampling variances of direct estimators for each domain}

\item{N}{Number of population in each area}

\item{method}{Method used to fit the Fay-Herriot model, which can be either "ML", "REML" or "FH" methods. Default is "REML" method}
}
\value{
This function returns a list of the following objects:
 \item{Est_Area3}{A dataframe with the values of Small Area Estimation with averaging pseudo area level model for sub-district level}
 \item{Est_Area2}{A dataframe with the values of Small Area Estimation with averaging pseudo area level model for region level}
 \item{Est_Area1}{A dataframe with the values of Small Area Estimation with averaging pseudo area level model for provincial level}
}
\description{
Provides function for small area estimation at area level
    using averaging pseudo area level model for variables of interest. A
    dataset produced by data generation are also provided. This package
    estimates small areas at the village level and then aggregates them to
    the sub-district, region, and provincial levels.
}
\examples{
# Load Dataset
data(dataVill)
saeAVG.Pseudo <- avgPseudo(prov = dataVill$Area1, reg = dataVill$Area2, sub = dataVill$Area3,
                 vill = dataVill$Area4, y = dataVill$ydir_area4, x = dataVill$X1,
                 var = dataVill$vardir_area4, N = dataVill$N, method="REML")

# Result
saeAVG.Pseudo$Est_Area3
saeAVG.Pseudo$Est_Area2
saeAVG.Pseudo$Est_Area1

}
