% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_tag.R
\name{has_tag}
\alias{has_tag}
\title{A selector function to use in \pkg{tidyverse} functions}
\usage{
has_tag(tags)
}
\arguments{
\item{tags}{A character vector of tags you want to operate on}
}
\value{
A numeric vector containing the position of the columns with the
requested tags
}
\description{
A selector function to use in \pkg{tidyverse} functions
}
\examples{
## create safeframe
x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)
head(x)

if (require(dplyr) && require(magrittr)) {
  x \%>\%
    select(has_tag(c("mph", "distance"))) \%>\%
    head()
}
}
