% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_safeframe.R
\name{validate_safeframe}
\alias{validate_safeframe}
\title{Checks the content of a safeframe object}
\usage{
validate_safeframe(x, ...)
}
\arguments{
\item{x}{a \code{safeframe} object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A named list with tags in \code{x}
as list names and the related types as list values.}
}
\value{
If checks pass, a \code{safeframe} object; otherwise issues an error.
}
\description{
This function evaluates the validity of a \code{safeframe} object by checking the
object class, its tags, and the types of variables. It combines
validation checks made by \code{\link[=validate_types]{validate_types()}} and \code{\link[=validate_tags]{validate_tags()}}. See
'Details' section for more information on the checks performed.
}
\details{
The following checks are performed:
\itemize{
\item \code{x} is a \code{safeframe} object
\item variables in \code{x} have a well-formed \code{label} attribute
\item variables correspond to the specified types
}
}
\examples{

## create a valid safeframe
x <- cars |>
  make_safeframe(
    mph = "speed",
    distance = "dist"
  )
x

## validation
validate_safeframe(x,
  mph = c("numeric", "factor"),
  distance = "numeric"
)

## the below issues an error
## note: tryCatch is only used to avoid a genuine error in the example
tryCatch(validate_safeframe(x,
  mph = c("numeric", "factor"),
  distance = "factor"
), error = paste)
}
\seealso{
\itemize{
\item \code{\link[=validate_types]{validate_types()}} to check if variables have the right types
\item \code{\link[=validate_tags]{validate_tags()}} to perform a series of checks on the tags
}
}
