% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoteNew.R
\name{smoteNew}
\alias{smoteNew}
\title{smoteNew is a necessary function that modifies the SMOTE algorithm.}
\usage{
smoteNew(data.x, data.y, K, dup_size = 0, class.to.oversample)
}
\arguments{
\item{data.x}{A data frame or matrix of numeric-attributed dataset}

\item{data.y}{A vector of a target class attribute corresponding to a dataset X}

\item{K}{The number of nearest neighbors during sampling process}

\item{dup_size}{The number or vector representing the desired times of synthetic minority instances over the original number of majority instances}

\item{class.to.oversample}{Class to be oversampled}
}
\description{
smoteNewis a necessary function that modifies the SMOTE algorithm in the following ways: (1) correct bug in original
smotefamily::SMOTE() function and (2) lets the user specifiy which class to be oversampled.
}
\examples{
library(smotefamily)
library(sambia)
data.example = sample_generator(10000,ratio = 0.80)
genData = sambia:::smoteNew(data.example[,-3],data.example[,3],K = 5,class.to.oversample = 'p')
}
\author{
Norbert Krautenbacher, Kevin Strauss, Maximilian Mandl, Christiane Fuchs
}
