% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e4m.R
\name{e4m}
\alias{e4m}
\title{Statistical errors for the estimation of a single mean}
\usage{
e4m(N, n, mu, sigma, DEFF = 1, conf = 0.95, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{mu}{The value of the estimated mean of the variable of interest.}

\item{sigma}{The value of the standard deviation of the variable of interest.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\value{
The coefficient of variation and the margin of error for a predefined sample size.
}
\description{
This function computes the cofficient of variation and the standard error when estimating a single mean under a complex sample design.
}
\details{
We note that the coefficent of variation is defined as: \deqn{cve = \frac{\sqrt{Var(\bar{y}_S)}}{\bar{y}_S}} 
Also, note that the magin of error is defined as: \deqn{\varepsilon = z_{1-\frac{\alpha}{2}}\sqrt{Var(\bar{y}_S)}}
}
\examples{
e4m(N=10000, n=400, mu = 10, sigma = 10)
e4m(N=10000, n=400, mu = 10, sigma = 10, plot=TRUE)
e4m(N=10000, n=400, mu = 10, sigma = 10, DEFF=3.45, conf=0.99, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
