% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4HHSm.R
\name{ss4HHSm}
\alias{ss4HHSm}
\title{Sample Sizes for Household Surveys in Two-Stages for Estimating Single Means}
\usage{
ss4HHSm(N, M, rho, mu, sigma, delta, conf, m)
}
\arguments{
\item{N}{The population size.}

\item{M}{Number of clusters in the population.}

\item{rho}{The Intraclass Correlation Coefficient.}

\item{mu}{The value of the estimated mean of a variable of interest.}

\item{sigma}{The value of the estimated standard deviation of a variable of interest.}

\item{delta}{The maximun margin of error that can be allowed for the estimation.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{m}{(vector) Number of households selected within PSU.}
}
\value{
This function returns a grid of possible sample sizes. 
The first column represent the design effect,
the second column is the number of clusters to be selected, 
the third column is the number of units to be selected inside the clusters, 
and finally, the last column indicates the full sample size induced by this particular strategy.
}
\description{
This function computes a grid of possible sample sizes for estimating single means under two-stage sampling designs.
}
\details{
In two-stage (2S) sampling, the design effect is defined by
\deqn{DEFF = 1 + (\bar{m}-1)\rho} 
Where \eqn{\rho} is defined as the intraclass correlation coefficient,  
\eqn{\bar{m}} is the average sample size of units selected inside each cluster. 
The relationship of the full sample size of the two stage design (2S) with the 
simple random sample (SI) design is given by
\deqn{ n_{2S} =  n_{SI}*DEFF}
}
\examples{

ss4HHSm(N = 50000000, M = 3000, rho = 0.034, 
        mu = 10, sigma = 2, delta = 0.03, conf = 0.95,
        m = c(5:15))

##################################
# Example with BigCity data      #
# Sample size for the estimation #
# of the unemployment rate       #
##################################

library(TeachingSampling)
data(BigCity)

BigCity1 <- BigCity \%>\% 
            group_by(HHID) \%>\%
            summarise(IncomeHH = sum(Income),
                      PSU = unique(PSU))
                      
summary(BigCity1$IncomeHH)
mean(BigCity1$IncomeHH)
sd(BigCity1$IncomeHH)

N <- nrow(BigCity)
M <- length(unique(BigCity$PSU))
rho <- ICC(BigCity1$IncomeHH, BigCity1$PSU)$ICC
mu <- mean(BigCity1$IncomeHH)
sigma <- sd(BigCity1$IncomeHH)
delta <- 0.05
conf <- 0.95
m <- c(5:15)
ss4HHSm(N, M, rho, mu, sigma, delta, conf, m)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ICC}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
