% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4m.R
\name{ss4m}
\alias{ss4m}
\title{The required sample size for estimating a single mean}
\usage{
ss4m(
  N,
  mu,
  sigma,
  DEFF = 1,
  conf = 0.95,
  error = "cve",
  delta = 0.03,
  plot = FALSE
)
}
\arguments{
\item{N}{The population size.}

\item{mu}{The value of the estimated mean of a variable of interest.}

\item{sigma}{The value of the estimated standard deviation of a variable of interest.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default conf = 0.95. By default \code{conf = 0.95}.}

\item{error}{The type of error you want to minimize.}

\item{delta}{The magnitude of the error you want to minimize.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\description{
This function returns the minimum sample size required for estimating a single mean subjec to predefined errors.
}
\details{
Note that the minimun sample size to achieve a relative margin of error \eqn{\varepsilon} is defined by: 
\deqn{n = \frac{n_0}{1+\frac{n_0}{N}}}
Where \deqn{n_0=\frac{z^2_{1-\frac{alpha}{2}}S^2}{\varepsilon^2 \mu^2}}
and
\deqn{S^2=\sigma^2 DEFF}
Also note that the minimun sample size to achieve a coefficient of variation \eqn{cve} is defined by:
\deqn{n = \frac{S^2}{\bar{y}_U^2 cve^2 + \frac{S^2}{N}}}
}
\examples{
ss4m(N=10000, mu=10, sigma=2, DEFF = 2, error = "cve", delta = 0.03, plot=TRUE)
ss4m(N=10000, mu=10, sigma=2, DEFF = 2, error = "me", delta = 1, plot=TRUE)
ss4m(N=10000, mu=10, sigma=2, DEFF = 2, error = "rme", delta = 0.03, plot=TRUE)

##########################
# Example with Lucy data #
##########################

data(Lucy)
attach(Lucy)
N <- nrow(Lucy)
mu <- mean(Income)
sigma <- sd(Income)
# The minimum sample size for simple random sampling
ss4m(N, mu, sigma, DEFF=1, conf=0.95, error = "rme", delta = 0.03, plot=TRUE)
# The minimum sample size for a complex sampling design
ss4m(N, mu, sigma, DEFF=1, conf=0.95, error = "me", delta = 5, plot=TRUE)
# The minimum sample size for a complex sampling design
ss4m(N, mu, sigma, DEFF=3.45, conf=0.95, error = "rme", delta = 0.03, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{e4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
