% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovarianceMatrix.R
\name{CovMat.Design}
\alias{CovMat.Design}
\title{covariance matrix for the multivariate normal distributed variables}
\usage{
CovMat.Design(K, J, I, sigma.1.q, sigma.2.q = NULL, sigma.3.q)
}
\arguments{
\item{K}{number of timepoints or measurments (design parameter)}

\item{J}{number of subjects}

\item{I}{number of clusters (design parameter)}

\item{sigma.1.q}{variance of the lowest level (error variance or within subject variance)}

\item{sigma.2.q}{secound level variance (e.g. within cluster and between subject variance),  by default NULL and then a cross-sectional type}

\item{sigma.3.q}{third level variance (e.g. between cluster variance)}
}
\value{
V covariance matrix
}
\description{
covariance matrix of the normal distribution under cluster randomized study type given a design and a type
}
\examples{
K<-6  #measurement (or timepoints)
I<-10 #Cluster
J<-2 #number of subjects

sigma.1<-0.1
sigma.3<-0.9
CovMat.Design(K, J, I,sigma.1.q=sigma.1, sigma.3.q=sigma.3)

sigma.1<-0.1
sigma.2<-0.4
sigma.3<-0.9
CovMat.Design(K, J, I,sigma.1.q=sigma.1, sigma.2.q=sigma.2, sigma.3.q=sigma.3)
}

