% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{h_add_sanity_check}
\alias{h_add_sanity_check}
\title{Wrapper for \link{add_sanity_check} for internal use}
\usage{
h_add_sanity_check(
  ellipsis,
  fail_vec,
  .generated_desc,
  data,
  data_name = "",
  param_name = "",
  call = h_deparsed_sys_call(which = -2),
  .fail_vec_str = checkmate::vname(x = fail_vec)
)
}
\arguments{
\item{ellipsis}{usually list(...) of the function that calls this function.
It contains the parameters defined by the user for add_sanity_check.}

\item{fail_vec}{logical vector where \code{TRUE} indicates that a
fail has happend}

\item{.generated_desc}{will be passed to \link{.add_sanity_check} if ellipsis
does not contain a element with name 'description'}

\item{data}{will be passed to \link{.add_sanity_check} if ellipsis
does not contain a element with name 'data'}

\item{data_name}{will be passed to \link{.add_sanity_check} if ellipsis
does not contain a element with name 'data_name'}

\item{param_name}{will be passed to \link{.add_sanity_check} if ellipsis
does not contain a element with name 'param_name'}

\item{call}{will be passed to \link{.add_sanity_check} if ellipsis
does not contain a element with name 'call'}

\item{.fail_vec_str}{usually not used by the user. Captures what
was passed to \code{fail_vec}.}
}
\value{
see return value of \link{add_sanity_check}
}
\description{
The convenience function usually provide some defaults
like description that can be overwritten by the user
through the ... argument of the convenience function.
This function manages to set those values that were
NOT overwritten by the user through the ... argument
and then call \link{add_sanity_check}.
}
\examples{
d <- data.frame(type = letters[1:4], nmb = 1:4)
# h_add_sanity_check is used on sc_col_elements()
sc_col_elements(object = d, col = "type", feasible_elements = letters[2:4])
get_sanity_checks()
}
