% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{h_complete_list}
\alias{h_complete_list}
\title{Extends a list with an named element if the element does not exist}
\usage{
h_complete_list(ell, name, value)
}
\arguments{
\item{ell}{list to be extended (usually an ellipsis as list(...))}

\item{name}{character with the name for the element to be added}

\item{value}{value that will be stored in \code{ell[[el_name]]}}
}
\value{
if \code{ell} already contained the element \code{name}, then
  \code{ell} is returned without being modified. Otherwise, \code{ell}
  is returned extended by a new element with name \code{name} and value
  \code{value}.
}
\description{
Extends a list with an named element if the element does not exist
}
\examples{
ell <- list(a = 1, b = 2)
sanityTracker:::h_complete_list(ell = ell, name = "a", value = 100)
sanityTracker:::h_complete_list(ell = ell, name = "d", value = Inf)
}
