% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quads.R
\name{sanzo.quad}
\alias{sanzo.quad}
\title{Generate four-colored palettes}
\usage{
sanzo.quad(palette_name)
}
\arguments{
\item{palette_name}{The short ID for the palette, e.g. "c263". For full list of quad IDs, use sanzo.info4().}
}
\value{
A vector of hexademicals of length 3.
}
\description{
Generate four-colored palettes.
}
\examples{
# Assign palette to a name.
my_palette <- sanzo.quad("c252")

# Concatenate two quads for a custom eight-colored palette.
c348 <- sanzo.quad("c348")
c341 <- sanzo.quad("c341")
custom_eight <- c(c348, c341)

# Use with base R.
plot(iris$Sepal.Width,
     iris$Sepal.Length,
     col = sanzo.quad("c341"))

# For examples of use with ggplot2, see https://github.com/jmaasch/sanzo.

# For examples of use as a gradient, see https://github.com/jmaasch/sanzo.

}
