% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_dplyr.R
\name{sfn_mutate_at}
\alias{sfn_mutate_at}
\title{Mutate selected columns by function}
\usage{
sfn_mutate_at(sfn_data, .vars, .funs, ..., solar = FALSE)
}
\arguments{
\item{sfn_data}{\code{sfn_data} or \code{sfn_data_multi} object to subset}

\item{.vars}{Variables to mutate. Passed to \code{\link[dplyr]{mutate_at}}}

\item{.funs}{Function/s for mutate, passed to \code{\link[dplyr]{mutate_at}}}

\item{...}{Extra arguments to pass to the functions in \code{.funs}, passed
to \code{\link[dplyr]{mutate_at}}.}

\item{solar}{Logical indicating if solar timestamp must used to subset}
}
\value{
For \code{sfn_data} objects, a mutated \code{sfn_data}. For
  \code{sfn_data_multi} another \code{sfn_data_multi} with the sites mutated
}
\description{
Port of \code{\link[dplyr]{mutate_at}} for \code{sfn_data} and
\code{sfn_data_multi} objects
}
\details{
`sfn_mutate_at` function will maintain the same number of rows before and
after the modification, so it is well suited to modify variables without
creating TIMESTAMP gaps (i.e. to change variable units). For mutating
individual variables see \code{\link{sfn_mutate}}.
}
\examples{
library(dplyr)
library(lubridate)

# data
data('ARG_TRE', package = 'sapfluxnetr')

# transform to NAs any sapflow value occured with wind speed above 25
ws_threshold <- 25
# get the names of the variables to mutate (tree names)
vars_to_mutate <- names(get_sapf_data(ARG_TRE)[,-1]) # no TIMESTAMP

sfn_mutate_at(
  ARG_TRE,
  .vars = vars(one_of(vars_to_mutate)),
  .funs = list(
    ~ case_when(
      ws > ws_threshold ~ NA_real_,
      TRUE ~ .
    )
  )
)

## multi
data(ARG_MAZ, package = 'sapfluxnetr')
data(AUS_CAN_ST2_MIX, package = 'sapfluxnetr')
multi_sfn <- sfn_data_multi(ARG_TRE, ARG_MAZ, AUS_CAN_ST2_MIX)

## in multi it's better to discard the variables to not mutate:
vars_to_not_mutate <- names(get_env_data(ARG_TRE)) # all the environmental

multi_sfn_mutated <- sfn_mutate_at(
  multi_sfn,
  .vars = vars(-one_of(vars_to_not_mutate)), # we use -
  .funs = list(
    ~ case_when(
      ws > ws_threshold ~ NA_real_,
      TRUE ~ .
    )
  )
)

multi_sfn_mutated[['ARG_TRE']]

}
