% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceSP.R
\name{distanceSP}
\alias{distanceSP}
\title{Compute pairwise distances between snow profiles}
\usage{
distanceSP(
  SPx,
  SP2 = NULL,
  output = "dist",
  n_cores = NULL,
  symmetric = TRUE,
  fast_summary = FALSE,
  fast_summary_weights = clusterSPconfig()$args_fast,
  progressbar = requireNamespace("progress", quietly = TRUE),
  ...
)
}
\arguments{
\item{SPx}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} object (or a single snowprofile if SP2 is provided)}

\item{SP2}{a \link[sarp.snowprofile:snowprofile]{sarp.snowprofile::snowprofile} object if SPx is also a snowprofile and a single pairwise distance is to be computed}

\item{output}{type of output to return, either a class \code{dist} (default) or \code{matrix}}

\item{n_cores}{number of nodes to create for a cluster using the  parallel package to do distance matrix calculation in parallel (default is serial calculations)}

\item{symmetric}{only compute one of two alignments dtwSP(A, B) or dtwSP(B, A) rather than taking the min distance (when diminished accuracy is
favourable to speed up run times for large number of profiles)}

\item{fast_summary}{Option to compute distances from basic summary stats instead of layerwise comparisons}

\item{fast_summary_weights}{A named numeric vector with relative weights for each snowpack property. Must be in exact
order, but do not need to be normalized.  Use \link{clusterSPconfig}$args_fast for template. See details for summary stats that have been implemented.}

\item{progressbar}{Do you want to print a progress bar with recommended package 'progress'? (only works for n_core = NULL)}

\item{...}{arguments passed to \link{dtwSP} and further to \link{simSP}. \code{simType} from \link{simSP} is an important choice.}
}
\value{
Either a dist or matrix object with pairwise distances (depending on \code{output} argument)
}
\description{
Calculate the distance between all combinations of snowprofiles in a snowprofileSet by:
}
\details{
\enumerate{
\item Matching their layers and aligning them (i.e., warp one profile onto the other one)
\item Assessing the similarity of the aligned profiles based on avalanche hazard relevant characteristics
\item Convert the similarity score into a distance value between \verb{[0, 1]}
}

This procedure is useful for clustering and aggregating tasks, given a set of multiple profiles.

When computing the distance matrix this routine calls \link{simSP} for
\emph{every possible pair} of profiles among the group. During that call the profile pair is aligned by \link{dtwSP}
and the aligned pair is evaluated by \link{simSP}.

Note that the pairwise distance matrix is modified within the function call to represent a symmetric distance matrix.
That is, however, not originally the case, since \code{dtwSP(A, B) != dtwSP(B, A)}. The matrix is therefore made symmetric by
setting the similarity between the profiles A and B to \verb{min(\{dtwSP(A, B), dtwSP(B, A)\})}.

Note that the number of possible profile pairs grows exponentially with the number of profiles in the group (i.e.,
O(n^2) calls, where n is the number of profiles in the group). Several option for improved performance include:
\itemize{
\item Using the \code{n_core} argument to activate thee \code{parallel} package. A suggestion value is the number of cores on your
system minus one \code{n_cores = parallel::detectCores() - 1}.
\item Setting \code{symmetric = FALSE} will only calculate \code{dtwSP(A, B)} and therefore not make the matrix symmetric, but cut the number of alignments in half
\item Setting \code{fast_summary = TRUE} will compute similarities from basic summary stats instead of aligning layers with dynamic time warping.
}

When using \code{fast_summary = TRUE}, you can provide custom weights to change the relative importance of the following snowpack properties:
\itemize{
\item \code{w_hs}: total snow height
\item \code{w_hn24}: height of snow in past 24 h
\item \code{w_hn72}: height of snow in past 72 h
\item \code{w_slab}: average hand hardness of snow in past 72 h
\item \code{w_gtype}: total thickness of layers grouped into new snow (PP, DF), pwls (SH, FC, DH), bulk (RG, FCxr) and melt (MF, MFcr, IF)
\item \code{w_gtype_rel}: \code{w_gtype} scaled by HS
\item \code{w_new}: total thickness of PP/DF layers
\item \code{w_pwl}: do critical weak layers exist in the top/middle/bottom thirds of the profile
\item \code{w_crust}: do melt-freeze crusts exist in the top/middle/bottom thirds of the profile
\item \code{w_rta}: maximum rta in the top/middle/bottom thirds of the profile
The number of stats computed depends on the \code{snowprofileLayer} properties available in the data.
}

@examples
\subsection{Simple serial calculation}{

distmat1 <- distanceSP(SPgroup2[1:4])
}

\subsection{Parallel calculation (uncomment)}{

#distmat2 <- distanceSP(SPgroup2[1:4], n_cores = parallel::detectCores() - 1)
}

\subsection{Fast summary method}{

distmat3 <- distanceSP(SPgroup2, fast_summary = T)
}

\subsection{View the default weights, then recalculate the distances with adjusted weights}{

print(clusterSPconfig()$args_fast)
weights <- c(w_hs = 3, w_hn24 = 0, w_h3d = 2, w_slab = 0,
w_gtype = 0, w_gtype_rel = 0, w_new = 0,
w_pwl = 0, w_crust = 1, w_rta = 1)
distmat4 <- distanceSP(SPgroup2, fast_summary = T, fast_summary_weights = weights)
}
}
\seealso{
\link{simSP}, \link{medoidSP}, \link{clusterSP}
}
\author{
shorton fherla
}
