% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sblgwas.R
\name{sblgwas}
\alias{sblgwas}
\title{Sparse Bayesian Learning for QTL Mapping and Genome-Wide Association Studies}
\usage{
sblgwas(x, y, z, t = -1, max.iter = 200, min.err = 1e-06)
}
\arguments{
\item{x}{a design matrix for fixed effects}

\item{y}{a vector of response variables}

\item{z}{a design matrix for random effects}

\item{t}{a number between [-2,0] to control sparseness of the model,
default is -1.}

\item{max.iter}{maximum number of iterations set by user to stop the program,
default is 200.}

\item{min.err}{minimum threshold of mean squared error of random effects estimated
from the current and the previous iteration to stop the program, default is 1e-6.}
}
\value{
\item{iteration}{a matrix storing intermediate results of each iteration before
the entire program converges, including \cr

"\code{iter}" iteration indicator \cr

"\code{error}" mean squared error of random effects estimated from the current and
the previous iteration \cr

"\code{s2}" estimated variance of residual error \cr

"\eqn{beta[1]\dots beta[p]}" estimates of fixed effects \cr

"\eqn{gamma[1]\dots gamma[m]}" estimates of random effects}

\item{parm}{a vector containing 5 elements: "\code{iter}", "\code{error}",
"\code{s2}", "\code{beta}" and "\code{df}" \cr

"\code{iter}" the number of iterations required by program to stop \cr

"\code{error}" mean square error of random effect estimated from the last iteration
before the program stops \cr

"\code{s2}" estimated variance of residual error \cr

"\code{beta}" estimate of fixed effect \cr

"\code{df}" the effective degree of freedom from total random effects}

\item{blup}{a matrix containing 4 columns: "\code{gamma}", "\code{vg}",
"\code{wald}" and "\code{p_wald}" \cr

"\code{gamma}" estimate of random effect \cr

"\code{vg}" estimated variance of random effect \cr

"\code{wald}" Wald statistic calculated as \eqn{\gamma^2}/\eqn{\Phi}

"\code{p_wald}" the \emph{p}-value of Wald statistic following Chi-squared
distribution with 1 degree of freedom}
}
\description{
The sparse Bayesian learning (SBL) method for quantitative trait
locus (QTL) mapping and genome-wide association studies (GWAS)
deals with a linear mixed model. This is also
a multiple locus model that includes all markers (random effects) in a single
model and detect significant markers simultaneously. SBL method adopts
coordinate descent algorithm to update parameters by estimating one parameter
at a time conditional on the posterior modes of all other parameters. The parameter
estimation process requires multiple iterations and the final estimated
parameters take the values when the entire program converges.
}
\details{
The multiple locus hierarchical linear mixed model of SBL is
\deqn{y=X\beta+Z\gamma+\epsilon}
where y is an \eqn{n*1} vector of response variables (observations of the trait);
X is an \eqn{n*p} design matrix for fixed effects; \eqn{\beta} is a \eqn{p*1}
vector of fixed effect; Z is an \eqn{n*m} genotype indicator matrix;
\eqn{\gamma} is an \eqn{m*1} vector of marker effects and \eqn{\epsilon} is
an \eqn{n*1} vector of residual errors with an aassumed
\eqn{\epsilon~N(0,\Sigma)} distribution. Each marker effect, \eqn{\gamma[k]}
for marker \emph{k}, is treated as a random variable following \eqn{N(0,\Phi[k])}
distribution, where \eqn{\Phi[k]} is the prior variance. The estimate of
\eqn{\gamma[k]} is best linear unbiased prediciton (BLUP). The estimate of
\eqn{\Phi[k]} is miximum likelihood estimate (MLE).
}
\examples{
# Load example data from sbl package
data(gen)
data(phe)
data(intercept)

# Run sblgwas() to perform association study of example data
# setting t = 0 leads to the most sparse model
fit<-sblgwas(x=intercept, y=phe, z=gen, t=0)
my.blup<-fit$blup

# setting t = -2 leads to the least sparse model
fit<-sblgwas(x=intercept, y=phe, z=gen, t=-2)
my.blup<-fit$blup
}
\author{
Meiyue Wang and Shizhong Xu \cr
Maintainer: Meiyue Wang \email{mwang024@ucr.edu}
}
