% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tissue.R
\name{GenerateTissue}
\alias{GenerateTissue}
\title{Generate Tissue}
\usage{
GenerateTissue(
  sim_object,
  k = NA,
  xmin = NA,
  xmax = NA,
  ymin = NA,
  ymax = NA,
  sdmin = 1/2,
  sdmax = 2,
  force = FALSE,
  density_heatmap = FALSE,
  step_size = 1,
  cores = 1,
  overwrite = FALSE,
  use_window = FALSE
)
}
\arguments{
\item{sim_object}{A \code{SpatSimObj} created with
\code{\link{CreateSimulationObject}}.}

\item{k}{Number of clusters to generate for each pattern}

\item{xmin}{Minimum x-coordinate for cluster centers.}

\item{xmax}{Maximum x-coordinate for cluster centers.}

\item{ymin}{Minimum y-coordinate for cluster centers.}

\item{ymax}{Maximum y-coordinate for cluster centers.}

\item{sdmin}{Minimum standard deviation for cluster kernels.}

\item{sdmax}{Maximum standard deviation for cluster kernels.}

\item{force}{Logical, whether to force generation of tissue even if the
generated cluster centers would fall outside the simulation window. If
\code{FALSE}, an error will be thrown if cluster centers are outside the
window.}

\item{density_heatmap}{Logical, whether to calculate a density heatmap for
the simulated tissue. If \code{TRUE}, a grid of points will be generated
covering the entire simulation window, and the probability of each grid
point belonging to tissue 1 will be calculated based on the generated tissue
probability.}

\item{step_size}{Grid step size for the density heatmap.}

\item{cores}{Number of cores to use for parallel processing of density
calculations.}

\item{overwrite}{boolean whether to overwrite if tissue kernels already exist}

\item{use_window}{boolean whether to use the simulation window to set x and y limits}
}
\value{
A modified 'Spatial Simulation Object' with updated tissue grids and
assigned tissue types for each simulated pattern.
}
\description{
This function generates a simulated tissue using a specified number of
clusters and spatial parameters for each pattern in the simulation object.
The tissue is represented by a grid of points with probabilities of
belonging to tissue 1 or tissue 2, based on a Gaussian kernel density
estimate calculated for each pattern
}
\details{
This function generates a simulated tissue for each pattern in the
simulation object by first generating k clusters within the specified x
and y ranges and with a standard deviation within the specified range.
Then, a Gaussian kernel density estimate is calculated for each pattern
using the generated clusters as center points and the specified standard
deviation as kernel size. The density estimates represent the probability
of each point in the simulation window belonging to tissue 1 or tissue 2.
If \code{density_heatmap = TRUE}, a density heatmap will be
calculated using a grid of points covering the entire simulation window.
Finally, for each simulated point, the probability of belonging to
tissue 1 is calculated based on the kernel density estimate, and the tissue
type is assigned with
probability proportional to the probability of belonging to tissue 1.
}
\examples{
# Create a simulation object with a window and point pattern
sim_object <- CreateSimulationObject()

#simulate points
sim_object <- GenerateSpatialPattern(sim_object, lambda = 20)

# Generate tissue with default parameters
sim_object <- GenerateTissue(sim_object)

}
