
# This file is automatically generated, you probably don't want to edit this

scatOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "scatOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            x = NULL,
            y = NULL,
            group = NULL,
            marg = "none",
            line = "none",
            se = FALSE, ...) {

            super$initialize(
                package='scatr',
                name='scat',
                requiresData=TRUE,
                ...)

            private$..x <- jmvcore::OptionVariable$new(
                "x",
                x,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..y <- jmvcore::OptionVariable$new(
                "y",
                y,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal"),
                permitted=list(
                    "nominal",
                    "nominaltext",
                    "ordinal"),
                default=NULL)
            private$..marg <- jmvcore::OptionList$new(
                "marg",
                marg,
                options=list(
                    "none",
                    "dens",
                    "box"),
                default="none")
            private$..line <- jmvcore::OptionList$new(
                "line",
                line,
                options=list(
                    "none",
                    "linear",
                    "smooth"),
                default="none")
            private$..se <- jmvcore::OptionBool$new(
                "se",
                se,
                default=FALSE)

            self$.addOption(private$..x)
            self$.addOption(private$..y)
            self$.addOption(private$..group)
            self$.addOption(private$..marg)
            self$.addOption(private$..line)
            self$.addOption(private$..se)
        }),
    active = list(
        x = function() private$..x$value,
        y = function() private$..y$value,
        group = function() private$..group$value,
        marg = function() private$..marg$value,
        line = function() private$..line$value,
        se = function() private$..se$value),
    private = list(
        ..x = NA,
        ..y = NA,
        ..group = NA,
        ..marg = NA,
        ..line = NA,
        ..se = NA)
)

scatResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        scat = function() private$.items[["scat"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Scatterplot")
            self$add(jmvcore::Image$new(
                options=options,
                name="scat",
                title="",
                renderFun=".scat",
                clearWith=list(
                    "x",
                    "y",
                    "group",
                    "marg",
                    "line",
                    "se")))}))

scatBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "scatBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'scatr',
                name = 'scat',
                version = c(1,0,0),
                options = options,
                results = scatResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Scatterplot
#'
#' Function for making clean, good looking scatter plots with the option to 
#' add marginal denisty or box plots.
#'
#' @examples
#' set.seed(1337)
#'
#' X <- rnorm(100)
#' Y <- 0.5*X + rnorm(100)
#' dat <- data.frame(X = X, Y = Y)
#'
#' scat(dat, x = 'X', y = 'Y', line = 'linear', se = TRUE, marg = 'dens')
#'
#' @param data the data as a data frame
#' @param x a string naming the variable from \code{data} that contains the  x
#'   coordinates of the points in the plot, variable must be numeric
#' @param y a string naming the variable from \code{data} that contains the  y
#'   coordinates of the points in the plot, variable must be numeric
#' @param group a string naming the variable from \code{data} that represents
#'   the  grouping variable
#' @param marg \code{none} (default), \code{dens}, or \code{box}, provide
#'   respectively no plots, density plots, or box plots on the axes
#' @param line \code{none} (default), \code{linear}, or \code{smooth}, provide
#'   respectively no regression line,  a linear regression line, or a smoothed
#'   regression line
#' @param se \code{TRUE} or \code{FALSE} (default), show the standard error
#'   for the regression line
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$scat} \tab \tab \tab \tab \tab a scatter plot \cr
#' }
#'
#' @export
scat <- function(
    data,
    x,
    y,
    group = NULL,
    marg = "none",
    line = "none",
    se = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('scat requires jmvcore to be installed (restart may be required)')

    options <- scatOptions$new(
        x = x,
        y = y,
        group = group,
        marg = marg,
        line = line,
        se = se)

    results <- scatResults$new(
        options = options)

    analysis <- scatClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
