% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.modify_conductance}
\alias{segment.modify_conductance}
\title{Transform the conductance states according to a user-defined function of conductance level.}
\usage{
segment.modify_conductance(segment, fun)
}
\arguments{
\item{segment}{the segment containing dwells and states.}

\item{fun}{a function on conductance levels (states)}
}
\value{
A modified copy of the original segment
}
\description{
Transform the conductance states according to a user-defined function of conductance level.
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

### Collapse into three subconductance states
fun <- function(amp) {
    if (amp < 0.3)
        return(0)
    else if (amp >= 0.3 && amp < 0.6)
        return(0.5)
    else
        return(1)
}

my_burst_d <- segment.modify_conductance(my_burst, fun)

}
