% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-sample.R
\name{ae_median_sample}
\alias{ae_median_sample}
\title{Absolute error of the median (sample-based version)}
\usage{
ae_median_sample(observed, predicted)
}
\arguments{
\item{observed}{A vector with observed values of size n}

\item{predicted}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, \code{predicted} can just be a vector of size n.}
}
\value{
Numeric vector of length n with the absolute errors of the median.
}
\description{
Absolute error of the median calculated as
\deqn{
  |\text{observed} - \text{median prediction}|
}
where the median prediction is calculated as the median of the predictive
samples.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-sample.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for sample-based forecasts
}
\if{latex}{
  \figure{metrics-sample.png}
}
}

\examples{
observed <- rnorm(30, mean = 1:30)
predicted_values <- matrix(rnorm(30, mean = 1:30))
ae_median_sample(observed, predicted_values)
}
\seealso{
\code{\link[=ae_median_quantile]{ae_median_quantile()}}
}
\keyword{metric}
