% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{calc_DY}
\alias{calc_DY}
\title{Calculate a DY variable (day of study)}
\usage{
calc_DY(tbl, DY_col, DTC_col, RFSTDTC = "RFSTDTC")
}
\arguments{
\item{tbl}{a data frame with the date column \code{RFSTDTC} and the column
specified by the \code{DTC_col} argument}

\item{DY_col}{string, the name of the new DY column to create}

\item{DTC_col}{string, the column in \code{tbl} which has the dates for which to
calculated the DY value; should either already have a date class or be a
character vector in the format YYYY-MM-DD}

\item{RFSTDTC}{a string, the column to use for \code{RFSTDTC}, default is
\code{"RFSTDTC"}; should either already have a date class or be a
character vector in the format YYYY-MM-DD}
}
\value{
a modified copy of \code{tbl} with the new DY column
}
\description{
Utilizes the DY method from the SDTM spec: \code{--DTC-RFSTDTC+1} if \code{--DTC} is on
or after RFSTDTC. \code{--DTC-RFSTDTC} if \code{--DTC} precedes \code{RFSTDTC}. This
function can also be used for the ENDY method from the spec which has the
same logic.
}
\examples{
df <- data.frame(
  DTC = c("2023-08-01", "2023-08-02", "2023-08-03", "2023-08-04"),
  RFSTDTC = rep("2023-08-02", 4)
)
calc_DY(df, DY_col = "XXDY", DTC_col = "DTC")

}
\seealso{
\code{\link[=create_BLFL]{create_BLFL()}}, \code{\link[=create_EPOCH]{create_EPOCH()}}
}
