% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{get_codelist}
\alias{get_codelist}
\title{Read in the code list from the specification for a specific domain}
\usage{
get_codelist(
  domain,
  dir,
  filename,
  var_col = "Variable",
  codelist_sheet = "Codelists",
  varid_col = "ID"
)
}
\arguments{
\item{domain}{string, SDTM domain or supplemental domain code}

\item{dir}{string, specification directory}

\item{filename}{string, file name of the specification}

\item{var_col}{a string, the column name in the domain spec sheet that
contains the variables for that domain, default is \code{"Variable"}}

\item{codelist_sheet}{a string, the sheet name of the spec's code list from
the spec's .xlsx file, default is \code{"Codelists"}}

\item{varid_col}{a string, the column name in the \code{codelist_sheet} table
from the spec's .xlsx file that contains the variable names, default is
\code{"ID"}}
}
\value{
a data frame with the code list
}
\description{
Reads-in the \code{"Codelists"} sheet from the study's specification MS Excel file
and then filters that code list by the variables in the domain
}
\examples{
work_dir <- system.file("extdata", package = "sdtmval")
codelists <- get_codelist(domain = 'XX',
                          dir = work_dir,
                          filename = "spec.xlsx")

}
\seealso{
\code{\link[=get_data_spec]{get_data_spec()}}, \code{\link[=get_key_vars]{get_key_vars()}}, \code{\link[=assign_meta_data]{assign_meta_data()}}
}
