% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{prepate_data}
\alias{prepate_data}
\title{Input data}
\usage{
prepate_data(
  settings,
  tsl,
  tsl_n = NULL,
  tsl_p = NULL,
  ts_start = NULL,
  ts_end = NULL,
  extend_weights = FALSE
)
}
\arguments{
\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{tsl}{time series list with all untransformed endogenous series}

\item{tsl_n}{time series list with nominal level series for aggregate output
\code{agg} and its subcomponents in \code{group1, group2}}

\item{tsl_p}{time series list with price series for aggregate output
\code{agg} and its subcomponents in \code{group1, group2}}

\item{ts_start}{start date, e.g. \code{c(2000, 2)} or \code{2000.25}}

\item{ts_end}{end date, e.g. \code{c(2000, 2)} or \code{2000.25}}

\item{extend_weights}{logical indicating if missing weights at beginning/end
of sample should be filled with the last/first available value}
}
\value{
A list with five components:
\item{tsm}{multiple time series object with all (transformed) endogeneous
variables}
\item{real}{multiple time series object with real series of
\code{agg, group1, group2}}
\item{nominal}{multiple time series object with nominal series of
\code{agg, group1, group2}}
\item{prices}{multiple time series object with price series of
\code{agg, group1, group2}}
\item{weights_growth}{list of multiple time series objects with weights for
the growth constraints, i.e., for series \code{group1, group2, subgroup1}
if applicable}
\item{weights_level}{list of multiple time series objects with weights for
the non linear level constraints, i.e., for series
\code{group1, group2, subgroup1} if applicable}
}
\description{
Prepares the required input data, it performs the
transformations to the raw data and computes the necessary weights for the
constraints.
}
\details{
Either \code{tsl_n} or \code{tsl_p} must be supplied.

Weights are forward/backward extended with the first/last value if
the supplied time series do not cover the entire period.
}
\examples{
data("data_ch")
settings <- initialize_settings()
data <- prepate_data(
  settings = settings,
  tsl = data_ch$tsl,
  tsl_n = data_ch$tsl_n
)
}
