% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{flowclusterTimeseries}
\alias{flowclusterTimeseries}
\title{Cluster a processed time-series with
\code{\link[flowClust:flowClust]{flowClust}} &
\code{\link[flowMerge:merge]{flowMerge}}.}
\usage{
flowclusterTimeseries(tset, ncpu = 1, K = 10, selected,
  merge = FALSE, B = 500, tol = 1e-05, lambda = 1, nu = 4,
  nu.est = 0, trans = 1, ...)
}
\arguments{
\item{tset}{processed time-series as provided by
\code{\link{processTimeseries}}}

\item{ncpu}{number of cores available for parallel mode of
\pkg{flowClust}. NOTE: parallel mode of
\code{\link[flowClust:flowClust]{flowClust}} is often non-functional.
Alternatively, you can set \code{options(mc.cores=ncpu)} directly.}

\item{K}{the requested cluster numbers (vector of integers)}

\item{selected}{a pre-selected cluster number  which is then
used as a start clustering for  \code{\link[flowMerge:merge]{flowMerge}}
(if option \code{merge==TRUE})}

\item{merge}{logical indicating whether cluster merging with
\code{\link[flowMerge:merge]{flowMerge}} should be attempted}

\item{B}{maximal number of EM iterations}

\item{tol}{tolerance for EM convergence}

\item{lambda}{initial Box-Cox trafo}

\item{nu}{degrees of freedom used for the t distribution, Inf for
pure Gaussian}

\item{nu.est}{0: no, 1: non-specific, 2: cluster-specific estimation of nu}

\item{trans}{0: no, 1: non-specific, 2: cluster-specific estim. of lambda}

\item{...}{further parameters for
\code{\link[flowClust:flowClust]{flowClust}}}
}
\description{
A wrapper for \code{\link[flowClust:flowClust]{flowClust}}, clustering
a time-series object \code{tset} provided by \code{\link{processTimeseries}},
where specifically the DFT of a time-series and requested data
transformation were calculated. This is intended to work in the same way
as \code{\link{clusterTimeseries}} but was so far only tested for
clustering of the final segment time-series, as previously applied
to microarray data from yeast by Machne & Murray (2012)
<doi:10.1371/journal.pone.0037906> and from cyanobacteria by Lehmann
et al. (2013) <doi:10.1186/1471-2105-14-133>.
It could in principle also be used for segmentation, but that has not
been extensively tested. \code{\link[flowClust:flowClust]{flowClust}}
implements a model-based clustering approach and is much slower then
\code{\link[stats:kmeans]{kmeans}} used in \code{\link{clusterTimeseries}}. 
Please see option \code{ncpu} on how to use parallel mode, which
does not work on some installations. However, model-based clustering has
the advantage of an intrinsic measure (\code{BIC}) to decide on the optimal
cluster numbers. Additionally, the clusters can be "merged" to fewer
clusters at constant \code{BIC} using
\code{\link[flowMerge:merge]{flowMerge}}.
}
\references{
Machne & Murray (2012)
    <doi:10.1371/journal.pone.0037906>
}
