% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.segments}
\alias{plot.segments}
\title{Plot method for the "segments" object.}
\usage{
\method{plot}{segments}(x, plot = c("S", "segments"), types, params,
  xaxis, show.fused = FALSE, ...)
}
\arguments{
\item{x}{a segmentation object as returned by
\code{\link{segmentClusters}} and \code{\link{segmentCluster.batch}}}

\item{plot}{string vector indicating which data should be plotted;
"segments": plot segments as arrows; "S1" plot the scoring vectors
\code{s(i,j,c} for all \code{c}; "S" plot the derivative of
matrix \code{S(i,c)} for all \code{c}}

\item{types}{a string vector indicating segment types to plot (a subset of
\code{x$ids}; defaults to all in \code{x$ids})}

\item{params}{a named vector of parameter settings used in
\code{\link{segmentCluster.batch}} allows to filter plotted segment
types, e.g. params=c(S="icor") will only plot segments where
the scoring function (parameter S) "icor" was used.}

\item{xaxis}{optional x-values to use as x-axis (e.g. to reflect absolute
chromosomal coordinates)}

\item{show.fused}{show the fuse tag as a black x}

\item{...}{additional arguments forwarded to
\code{\link[graphics:arrows]{arrows}}, eg. to set \code{lwd} for
for \code{plot="segments"}, or to \code{\link[graphics:matplot]{matplot}}
for \code{plot="S"}}
}
\description{
plot the final segmentation objects returned by
\code{\link{segmentClusters}} and \code{\link{segmentCluster.batch}}
}
