% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarity.R
\name{dissimilarity}
\alias{dissimilarity}
\title{Calculates Index of Dissimilarity}
\usage{
dissimilarity(
  data,
  group,
  unit,
  weight = NULL,
  se = FALSE,
  CI = 0.95,
  n_bootstrap = 100
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed. The D index only
allows two distinct groups.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{se}{If \code{TRUE}, the segregation estimates are bootstrapped to provide
standard errors and to apply bias correction. The bias that is reported
has already been applied to the estimates (i.e. the reported estimates are "debiased")
(Default \code{FALSE})}

\item{CI}{If \code{se = TRUE}, compute the confidence (CI*100)% confidence interval
in addition to the bootstrap standard error.
This is based on percentiles of the bootstrap distribution, and a valid interpretation
relies on a larger number of bootstrap iterations. (Default \code{0.95})}

\item{n_bootstrap}{Number of bootstrap iterations. (Default \code{100})}
}
\value{
Returns a data.table with one row. The column \code{est} contains
  the Index of Dissimilarity.
  If \code{se} is set to \code{TRUE}, an additional column \code{se} contains
  the associated bootstrapped standard errors, an additional column \code{CI} contains
  the estimate confidence interval as a list column, an additional column \code{bias} contains
  the estimated bias, and the column \code{est} contains the bias-corrected estimates.
}
\description{
Returns the total segregation between \code{group} and \code{unit} using
the Index of Dissimilarity.
}
\examples{
# Example where D and H deviate
m1 <- matrix_to_long(matrix(c(100, 60, 40, 0, 0, 40, 60, 100), ncol = 2))
m2 <- matrix_to_long(matrix(c(80, 80, 20, 20, 20, 20, 80, 80), ncol = 2))
dissimilarity(m1, "group", "unit", weight = "n")
dissimilarity(m2, "group", "unit", weight = "n")
}
\references{
Otis Dudley Duncan and Beverly Duncan. 1955. "A Methodological Analysis of Segregation Indexes,"
     American Sociological Review 20(2): 210-217.
}
