% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votes_get_clubs_links.R
\name{votes_get_clubs_links}
\alias{votes_get_clubs_links}
\title{Getting links with voting's results for each club}
\usage{
votes_get_clubs_links(home_page = 'http://www.sejm.gov.pl/Sejm8.nsf/',
  page)
}
\arguments{
\item{home_page}{main page of polish diet: http://www.sejm.gov.pl/Sejm8.nsf/}

\item{page}{voting's page}
}
\value{
data frame with two columns: club, links
}
\description{
Function \code{votes_get_clubs_links} gets links with voting's results for each club
from voting's page.
}
\details{
Function \code{votes_get_clubs_links} gets links with voting's results for each club
from voting's page. Example of a voting's page: 
http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?symbol=glosowania&
NrKadencji=7&NrPosiedzenia=1&NrGlosowania=1
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
home_page <- 'http://www.sejm.gov.pl/Sejm7.nsf/'
page <- paste0('http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?',
  'symbol=glosowania&NrKadencji=7&NrPosiedzenia=1&NrGlosowania=1')
votes_get_clubs_links(home_page, page)}

}
\author{
Piotr Smuda
}

