% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{seqmissfplot}
\alias{seqmissfplot}
\title{Plot the most common patterns of missing data.}
\usage{
seqmissfplot(data, var = NULL, with.complete = TRUE, void.miss = TRUE, ...)
}
\arguments{
\item{data}{Either a data frame containing sequences of a categorical
variable, where missing data are coded as \code{NA}, or a state sequence
object created using the \link[TraMineR]{seqdef} function.}

\item{var}{A vector specifying the columns of the dataset
that contain the trajectories. Default is \code{NULL}, meaning all columns
are used.}

\item{with.complete}{Logical, if \code{TRUE}, complete trajectories
will be included in the plot.}

\item{void.miss}{Logical, if \code{TRUE}, treats void elements as
missing values. Applies only to state sequence objects created with
\link[TraMineR]{seqdef}. Note that the default behavior of \code{seqdef}
is to treat missing data at the end of sequences as void elements.}

\item{...}{Additional parameters passed to the \link[TraMineR]{seqfplot}
function.}
}
\description{
This function plots the most frequent patterns of missing data, based on the
\link[TraMineR]{seqfplot} function.
}
\details{
This plot function is based on the \link[TraMineR]{seqfplot} function,
allowing users to visualize patterns of missing data within sequences.
For details on additional customizable arguments, see the
\link[TraMineR]{seqfplot} documentation.

By default, this function plots the 10 most frequent patterns. The number
of patterns to be plotted can be adjusted using the \code{idxs} argument
in \code{seqfplot}.
}
\examples{
# Plot the 10 most common patterns of missing data

seqmissfplot(gameadd, var = 1:4)

# Plot the 10 most common patterns of missing data discarding
# complete trajectories

seqmissfplot(gameadd, var = 1:4, with.missing = FALSE)

# Plot only the 5 most common patterns of missing data discarding
# complete trajectories

seqmissfplot(gameadd, var = 1:4, with.missing = FALSE, idxs = 1:5)

}
\author{
Kevin Emery
}
