% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{seqmissimplic}
\alias{seqmissimplic}
\title{Identification and visualization of states that best characterize sequences
with missing data}
\usage{
seqmissimplic(data, var = NULL, void.miss = TRUE, ...)
}
\arguments{
\item{data}{Either a data frame containing sequences of a categorical
variable, where missing data are coded as \code{NA}, or a state sequence
object created using the \link[TraMineR]{seqdef} function.}

\item{var}{A vector specifying the columns of the dataset
that contain the trajectories. Default is \code{NULL}, meaning all columns
are used.}

\item{void.miss}{Logical, if \code{TRUE}, treats void elements as
missing values. This argument applies only to state sequence objects created
with \link[TraMineR]{seqdef}. Note that the default behavior of
\link[TraMineR]{seqdef} is to treat missing data at the end of sequences as
void elements.}

\item{...}{parameters to be passed to the \link[TraMineRextras]{seqimplic}
function}
}
\value{
returns a \code{seqimplic} object that can be plotted and printed.
}
\description{
This function identifies and visualizes states that best characterize
sequences with missing data at each position (time point), comparing them to
sequences without missing data at each position (time point). It is based on
the \link[TraMineRextras]{seqimplic} function. For more information on the
methodology, see the \code{seqimplic} documentation.
}
\examples{

# For illustration purpose, we simulate missing data on the mvad dataset,
# available in the TraMineR package. The state "joblessness" state has a
# higher probability of triggering a missing gap

\dontrun{
data(mvad, package = "TraMineR")
mvad.miss <- seqaddNA(mvad, var = 17:86, states.high = "joblessness")

# The states that best characterize sequences with missing data
implic <- seqmissimplic(mvad.miss, var = 17:86)

# Visualization of the results
plot(implic)
}

}
\author{
Kevin Emery
}
