% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oscillators.R
\name{oscillator_square}
\alias{oscillator_square}
\title{Square oscillator}
\usage{
oscillator_square(freq = 440, duration = 1, phase = 0, rate = 44100)
}
\arguments{
\item{freq}{Numeric, note frequency in Hz}

\item{duration}{Numeric, note duration in second}

\item{phase}{Numeric, phase in radians (typically between 0 and 2*pi)}

\item{rate}{Numeric, sampling rate in Hz}
}
\value{
An object of class 'soundSample'.
}
\description{
Creates a soundSample using a square oscillator.
}
\examples{
sam <- oscillator_square(freq=220,duration=0.1)
plot(sam)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to listen to the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
listen(sam)}
}
