% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcs.tinf.R
\name{simcs.tinf}
\alias{simcs.tinf}
\title{collect cross-sectional data}
\usage{
simcs.tinf(
  lambda,
  n_samples,
  age_range,
  age_fixed = NA,
  antigen_isos,
  n_mcmc_samples = 0,
  renew_params = FALSE,
  ...
)
}
\arguments{
\item{lambda}{seroconversion rate (in events/person-day)}

\item{n_samples}{number of samples n_samples (= nr of simulated records)}

\item{age_range}{age range to use for simulating data, in days}

\item{age_fixed}{age_fixed for parameter sample
(age_fixed = NA for age at infection)}

\item{antigen_isos}{\link{character} \link{vector} with one or more antibody names.
Values must match \code{curve_params}.}

\item{n_mcmc_samples}{\itemize{
\item when \code{n_mcmc_samples} is in 1:4000,
a fixed posterior sample is used
\item when n_mcmc_samples = 0 a random sample is chosen
}}

\item{renew_params}{\itemize{
\item \code{renew_params = TRUE}
generates a new parameter set for each infection
\item \code{renew_params = FALSE}
keeps the one selected at birth, but updates baseline y0
}}

\item{...}{
  Arguments passed on to \code{\link[=simresp.tinf]{simresp.tinf}}
  \describe{
    \item{\code{predpar}}{an \code{\link[=array]{array()}} with dimensions named:
\itemize{
\item \code{antigen_iso}
\item \code{parameter}
\item \code{obs}
}}
  }}
}
\value{
an \code{\link[=array]{array()}} with dimensions
\code{n_samples}, \code{length(antigen_isos) + 1},
where rows are observations and columns are age and biomarkers y(t)
}
\description{
collect cross-sectional data
}
\keyword{internal}
