% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{fitted.sgdgmf}
\alias{fitted.sgdgmf}
\title{Extract the fitted values of a GMF models}
\usage{
\method{fitted}{sgdgmf}(object, ..., type = c("link", "response", "terms"), partial = FALSE)
}
\arguments{
\item{object}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of fitted values which should be returned}

\item{partial}{if \code{TRUE}, returns the partial fitted values}
}
\value{
If \code{type="terms"}, a list of fitted values containing the fields \code{XB},
\code{AZ} and \code{UV}. Otherwise, a matrix of fitted values in the link or
response scale, depending on the selected \code{type}.
}
\description{
Computes the fitted values of a GMF model.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
gmf = sgdgmf.fit(data$Y, ncomp = 3, family = poisson())

# Get the fitted values of a GMF model
str(fitted(gmf)) # returns the overall fitted values in link scale
str(fitted(gmf, type = "response")) # returns the overall fitted values in response scale

}
