% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Text}
\alias{Text}
\title{Text}
\usage{
Text(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Text is a component for displaying text. You can use Text to standardize text across your web app.

You can specify the \code{variant} prop to apply font styles to Text. This variant pulls from the Fluent UI React theme loaded on the page. If you do not specify the \code{variant} prop, by default, Text applies the styling from specifying the \code{variant} value to \code{medium}.

The Text control is inline wrap by default. You can specify \code{block} to enable block and \code{nowrap} to enable \code{nowrap}. For ellipsis on overflow to work properly, \code{block} and \code{nowrap} should be manually set to \code{true}.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Text}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ as } \verb{React.ElementType<React.HTMLAttributes<HTMLElement>>} \cr Optionally render the component as another component type or primitive.
\item \bold{ block } \code{boolean} \cr Whether the text is displayed as a block element.
}

Note that in order for ellipsis on overflow to work properly, \code{block} and \code{nowrap} should be set to true.
\itemize{
\item \bold{ nowrap } \code{boolean} \cr Whether the text is not wrapped.
}

Note that in order for ellipsis on overflow to work properly, \code{block} and \code{nowrap} should be set to true.
\itemize{
\item \bold{ variant } \verb{keyof IFontStyles} \cr Optional font type for Text.
}
}
\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  Text(variant = "xLarge", "Some text with a nice Fluent UI font")
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
