% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{Toggle}
\alias{Toggle}
\alias{Toggle.shinyInput}
\alias{updateToggle.shinyInput}
\title{Toggle}
\usage{
Toggle(...)

Toggle.shinyInput(inputId, ..., value = defaultValue)

updateToggle.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
A toggle represents a physical switch that allows someone to choose between two mutually exclusive options.  For example, “On/Off”, “Show/Hide”. Choosing an option should produce an immediate result.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Toggle}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ ariaLabel } \code{string} \cr Text for screen-reader to announce as the name of the toggle.
\item \bold{ as } \verb{IComponentAs<React.HTMLAttributes<HTMLElement>>} \cr Render the root element as another type.
\item \bold{ checked } \code{boolean} \cr Checked state of the toggle. If you are maintaining state yourself, use this property. Otherwise use \code{defaultChecked}.
\item \bold{ componentRef } \verb{IRefObject<IToggle>} \cr Optional callback to access the IToggle interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ defaultChecked } \code{boolean} \cr Initial state of the toggle. If you want the toggle to maintain its own state, use this. Otherwise use \code{checked}.
\item \bold{ disabled } \code{boolean} \cr Optional disabled flag.
\item \bold{ inlineLabel } \code{boolean} \cr Whether the label (not the onText/offText) should be positioned inline with the toggle control. Left (right in RTL) side when on/off text provided VS right (left in RTL) side when no on/off text. Caution: when not providing on/off text user may get confused in differentiating the on/off states of the toggle.
\item \bold{ keytipProps } \code{IKeytipProps} \cr Optional keytip for this toggle
\item \bold{ label } \code{string | JSX.Element} \cr A label for the toggle.
\item \bold{ offAriaLabel } \code{string} \cr
\item \bold{ offText } \code{string} \cr Text to display when toggle is OFF. Caution: when not providing on/off text user may get confused in differentiating the on/off states of the toggle.
\item \bold{ onAriaLabel } \code{string} \cr
\item \bold{ onChange } \verb{(event: React.MouseEvent<HTMLElement>, checked?: boolean) => void} \cr Callback issued when the value changes.
\item \bold{ onChanged } \verb{(checked: boolean) => void} \cr
\item \bold{ onText } \code{string} \cr Text to display when toggle is ON. Caution: when not providing on/off text user may get confused in differentiating the on/off states of the toggle.
\item \bold{ role } \code{'checkbox' | 'switch' | 'menuitemcheckbox'} \cr (Optional) Specify whether to use the "switch" role (ARIA 1.1) or the checkbox role (ARIA 1.0). If unspecified, defaults to "switch".
\item \bold{ styles } \verb{IStyleFunctionOrObject<IToggleStyleProps, IToggleStyles>} \cr Optional styles for the component.
\item \bold{ theme } \code{ITheme} \cr Theme provided by HOC.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item When people need to perform extra steps for changes to take effect, use a check box instead. For example, if they must click a "Submit", "Next", or "OK" button to apply changes, use a check box.
}
}

\subsection{Content}{
\itemize{
\item Only replace the On/Off labels if there are more specific labels for the setting. For example, you might use Show/Hide if the setting is "Show images".
\item Keep descriptive text short and concise—two to four words; preferably nouns. For example, "Focused inbox" or "WiFi".
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    Toggle.shinyInput(ns("toggle"), value = TRUE),
    textOutput(ns("toggleValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$toggleValue <- renderText({
      sprintf("Value: \%s", input$toggle)
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
