% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-searchbar.R
\docType{data}
\name{configurator}
\alias{configurator}
\title{Configuration Options List for mark.js API}
\format{
List with 15 named elements.
\describe{
\item{element}{Element tag to wrap matches, default is \code{"mark"}.}
\item{className}{Class named appended to the match element,
default is \code{""}.}
\item{exclude}{Vector of element selectors to exclude from match,
default is \code{c()}.}
\item{accuracy}{Match algorithm (\code{"partially"}, \code{"complementary"},
or \code{"exactly"}), default is \code{"partially"}.
(see \href{https://markjs.io/#mark}{mark.js API} for more details).}
\item{synonyms}{List of key-value pairs to consider equivalent,
default is \code{list()}.}
\item{ignorePunctuation}{Vector of punctuation marks to ignore,
default is \code{c()}.}
\item{wildcards}{Matching using wildcards such as "?" and "*"
(\code{"disabled"}, \code{"enabled"}, or \code{"withSpaces"}), default is \code{"disabled"}
(see \href{https://markjs.io/#mark}{mark.js API} for more details).}
\item{iframes}{Search within iframe elements, default is \code{FALSE}.}
\item{iframesTimeout}{Maximum time (in ms) to wait for load before
skipping an iframe element, default is \code{5000}.}
\item{seperateWordSearch}{Search for each space-seperated word instead
of the complete input, default is \code{TRUE}.}
\item{diacritics}{Match using diacritic characters, default is \code{TRUE}.}
\item{acrossElements}{Search for matches across elements,
default is \code{FALSE}.}
\item{caseSensitive}{Case sensitive matching, default is \code{FALSE}.}
\item{ignoreJoiners}{Skip soft hyphen, zero width space, zero width
non-joiner and zero width joiner, default is \code{FALSE}.}
\item{debug}{Print debug information to the brower's console,
default is \code{FALSE}.}
}
}
\usage{
configurator
}
\description{
All API options for mark.j v8.11.1, excluding the callback functions:
\code{each}, \code{filter}, \code{noMatch}, and \code{done}.
}
\details{
See the \href{https://markjs.io/#mark}{mark.js API} for a detailed
description of each option. Also see the mark.js
\href{https://markjs.io/configurator.html}{Configurator} for these
options in action.
}
\keyword{datasets}
