% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-searchbar.R
\name{searchbar}
\alias{searchbar}
\title{Create the searchbar widget.}
\usage{
searchbar(
  inputId,
  contextId,
  value = NULL,
  label = NULL,
  width = NULL,
  placeholder = NULL,
  counter = TRUE,
  cycler = TRUE,
  scrollBehavior = c("smooth", "auto"),
  markOpts = configurator,
  quiet = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{contextId}{The \code{input} slot of the element to be searched and
highlighted.}

\item{value}{Initial value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see `shiny::validateCssUnit()``.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{counter}{Include a counter to display the number of matches found.}

\item{cycler}{Include an interface to cycle between the matches.}

\item{scrollBehavior}{Behavior of scrolling with \code{cycler}, either \code{"auto"} or
"\code{smooth}"). The default is \code{"smooth"}.}

\item{markOpts}{Options to be passed to mark.js;
see \link{configurator} and the \href{https://markjs.io/#mark}{mark.js API}
for more details.}

\item{quiet}{Supress any warning related to incorrect/invalid arguments.}
}
\value{
A seachbar input control that can be added to a UI definition.
}
\description{
Create a textInput-like searchbar which can search through and highlight
the user's input within another element.
}
\details{
The \emph{counter} and \emph{cycler} arguments add additional functionality to the
searchbar. The \emph{counter} shows the user how many matches were found and
the \emph{cycler} gives the user an interface to cycle through each match with
automatic scrolling (using either the buttons or Enter and Shift+Enter).

The \emph{markOpts} are a list of options to pass to the underlying
\href{https://markjs.io/#mark}{mark.js API}, which handles finding and
highlighting the matches in element identified by \emph{contextId}.
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    searchbar("sb", "text"),
    textOutput("text")
  )
  server <- function(input, output) {
    output$text <- renderText("Hello world!")
  }
  shinyApp(ui, server)
}

}
\seealso{
\link{updateMarkOptions}, \link{configurator}
}
