% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qry_app_stitching.R
\name{qry_app_stitching}
\alias{qry_app_stitching}
\title{Retrieve structure of an app module}
\usage{
qry_app_stitching(appName, shinyMgrPath)
}
\arguments{
\item{appName}{The name of the app in the shinymgr database 
(e.g. iris_explorer)}

\item{shinyMgrPath}{File path to the main shiny manager project directory}
}
\value{
Dataframe consisting of the specified rows and columns
}
\description{
Returns a dataframe showing how outputs from one module are
"stitched" as inputs to downstream modules in a shinymgr app
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{

# set the file path to the main shinymgr directory
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

shinymgr_setup(parentPath = parentPath, demo = TRUE)

# get the structure of the iris_explorer app
qry_app_stitching(appName = "iris_explorer", shinyMgrPath = shinyMgrPath)

# remove demo
unlink(shinyMgrPath, recursive = TRUE)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other qry: 
\code{\link{qry_app_flow}()},
\code{\link{qry_insert}()},
\code{\link{qry_mod_info}()},
\code{\link{qry_row}()}
}
\concept{qry}
