% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qry_mod_info.R
\name{qry_mod_info}
\alias{qry_mod_info}
\title{Retrieve general information about a module}
\usage{
qry_mod_info(modName, shinyMgrPath)
}
\arguments{
\item{modName}{The name of the mod in the shinymgr database 
(e.g. subset_rows)}

\item{shinyMgrPath}{File path to the main shiny manager project directory}
}
\value{
Dataframe consisting of the specified rows and columns
}
\description{
Returns a dataframe showing a given module's arguments,
returns, and package dependencies.
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{
# set the file path to the main shinymgr directory
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

shinymgr_setup(parentPath = parentPath, demo = TRUE)

# get the details of the "subset_rows" modules
qry_mod_info(modName = "subset_rows", shinyMgrPath = shinyMgrPath)

#' # get the details of the "add_noise" modules
qry_mod_info(modName = "add_noise", shinyMgrPath = shinyMgrPath)

# remove demo
unlink(shinyMgrPath, recursive = TRUE)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other qry: 
\code{\link{qry_app_flow}()},
\code{\link{qry_app_stitching}()},
\code{\link{qry_insert}()},
\code{\link{qry_row}()}
}
\concept{qry}
