% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payload.R
\name{payload_ui}
\alias{payload_ui}
\title{Wrap an existing UI with an integrated POST handler on the same port}
\usage{
payload_ui(base_ui, path = "/ingress", token = NULL)
}
\arguments{
\item{base_ui}{The original UI (tagList, fluidPage, or a function(req) returning UI)}

\item{path}{The URL path to handle POST requests (default "/ingress")}

\item{token}{Optional authentication token for POST requests}
}
\value{
A function that takes a request object and returns either the regular UI
(for GET requests) or an HTTP response (for POST requests). This function
should be passed to shinyApp() as the ui parameter.
}
\description{
Wrap an existing UI with an integrated POST handler on the same port
}
\examples{
if (interactive()) {
ui <- payload_ui(
  fluidPage(h1("My App")),
  path = "/data",
  token = "secret123"
)
shinyApp(ui, server, uiPattern = ".*")
}
}
