% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{getSeriesData}
\alias{getSeriesData}
\title{Query time series}
\usage{
getSeriesData(series, startDate = NULL, endDate = NULL)
}
\arguments{
\item{series}{A vector containing idSeries}

\item{startDate}{A string with "yyyy-MM-dd" format. Defines the
date on which the period of obtained data starts.}

\item{endDate}{A string with "yyyy-MM-dd" format. Defines the
date on which the period of obtained data concludes.}
}
\value{
A vector containing the data series requested.
}
\description{
Recovers data of the indicated time series (up to 100)
from \href{http://www.banxico.org.mx/SieInternet}{SIE}.
}
\details{
The data series are queried throught the \href{https://www.banxico.org.mx/SieAPIRest}{SIE API}.
This API requieres that every request is identified by a token. The token can be requested
\href{https://www.banxico.org.mx/SieAPIRest/service/v1/token}{here}.
Once the query token has been obtained and prior to use any function from this Package,
the token must be set in the current query session, using the function \code{\link{setToken}}.

To get a data.frame representing one data series use \code{\link{getSerieDataFrame}}.
}
\examples{

\dontrun{
## You need a valid token to run the example
setToken("token")
idSeries <- c("SF43718","SF46410","SF46407")
series <- getSeriesData(idSeries, '2016-01-01','2018-07-12')

serie <- getSeriesData("SF43718")
}

}
