% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effFitAndSelect.R
\name{effFitAndSelect}
\alias{effFitAndSelect}
\alias{effContFitAndSelect}
\alias{effDiscFitAndSelect}
\title{Automatic Fitting and Selection of Effectiveness Distributions}
\usage{
effContFitAndSelect(x, method = "AIC", silent = TRUE)

effDiscFitAndSelect(x, support, method = "AIC", silent = TRUE)
}
\arguments{
\item{x}{a sample of effectiveness scores between 0 and 1, or a matrix or data frame of
topic-by-system scores.}

\item{method}{selection method. See \code{\link{effSelect}}.}

\item{silent}{logical: should the report of error messages be suppressed?}

\item{support}{the support of the distribution (see \code{\link{support}}).}
}
\value{
if \code{x} is a vector, the selected disttribution. If \code{x} is a matrix or data
  frame, a list of the selected distributions.
}
\description{
Automatic Fitting and Selection of Effectiveness Distributions
}
\examples{
e <- effContFitAndSelect(web2010ap[,1], method = "logLik")
c(e$mean, e$var)
e2 <- effContFitAndSelect(web2010ap[,2], method = "logLik")
c(e2$mean, e2$var)

ee <- effContFitAndSelect(web2010ap[,1:2], method = "logLik")
sapply(ee, function(e) c(e$mean, e$var)) # same as above
}
\seealso{
\code{\link{effFit}} and \code{\link{effSelect}}.
}
