% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2geno.R
\name{convert2geno}
\alias{convert2geno}
\title{Convert continuous allele information into marker genotypes}
\usage{
convert2geno(xodat, map, founder_geno = NULL, shift_map = FALSE)
}
\arguments{
\item{xodat}{The sort of detailed genotype/crossover data generated by
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}}}

\item{map}{vector of marker locations; can also be a list of such
vectors (one per chromosome), in which case xodat and founder_geno
must be lists with the same length.}

\item{founder_geno}{Optional matrix (size \code{n_founders} x
\code{length(map)}) of founder genotypes. If coded as 1/2 (or 1/3),
results are 1/2/3 genotypes. If coded as A/T/G/C/N, results are
A/T/G/C/N/H genotypes. If coded as letters A-H for the 8 founders,
results are two-letter genotypes AA-HH with 36 possible values.}

\item{shift_map}{If TRUE, shift genetic map to start at 0}
}
\value{
If \code{founder_geno} is provided or there are just two
founders, the result is a numeric matrix of genotypes, individuals
x markers, with genotypes 1/2/3 codes for 11/12/22 genotypes.

If \code{founder_geno} is not provided and there are more than two
founders, the result is a 3-dimensional array, individuals x
markers x alleles, with the third dimensional corresponding to the
maternal and paternal allele.

If the input \code{map} is a list (the components being
chromosomes), then \code{xodat} and \code{founder_geno} must be
lists of the same length, and the result will be a list of
matrices.
}
\description{
Convert the continuous crossover location information produced by
sim_from_pedigree to marker genotypes
}
\examples{
# simulate AIL pedigree
tab <- sim_ail_pedigree(12, 30)
# simulate data from that pedigree
dat <- sim_from_pedigree(tab)
# marker map (could also use sim.map in R/qtl)
map <- seq(0, 100, by=5)
names(map) <- paste0("marker", seq(along=map))
# convert data to marker genotypes
geno <- convert2geno(dat, map)


# AIL with multiple chromosomes
dat <- sim_from_pedigree(tab, c("1"=100, "2"=75, "X"=100), xchr="X")
# marker map
multmap <- list("1"=seq(0, 100, by=5),
                "2"=seq(0, 75, by=5),
                "X"=seq(0, 100, by=5))
for(i in 1:3)
  names(multmap[[i]]) <- paste0("marker", i, "_", 1:length(map[[i]]))
geno <- convert2geno(dat, multmap)

# simulate DO pedigree
tab <- sim_do_pedigree(8)
# simulate data from that pedigree
dat <- sim_from_pedigree(tab)
# simulate founder snp alleles
fg <- matrix(sample(1:2, 8*length(map), repl=TRUE), nrow=8)
# for DO, need female & male founders (to deal with X chr)
fg <- rbind(fg, fg)
# convert dat to SNP genotypes
geno <- convert2geno(dat, map, fg)
# if fg not provided, result is a 3d array
genoarray <- convert2geno(dat, map)
}
\seealso{
\code{\link[=get_geno]{get_geno()}}, \code{\link[=sim_from_pedigree]{sim_from_pedigree()}}
}
\keyword{utilities}
