% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cross.R
\name{plot_crosslines}
\alias{plot_crosslines}
\title{Plot cross lines}
\usage{
plot_crosslines(
  momloc,
  dadloc,
  kidsloc,
  gap = 3,
  chrlength = 30,
  cex = 1.5,
  lwd = 2,
  arrow_length = 0.1,
  col = "white",
  ...
)
}
\arguments{
\item{momloc}{An (x,y) vector with center location for mother}

\item{dadloc}{An (x,y) vector with center location for mother}

\item{kidsloc}{Either an (x,y) vector with center location for a
kid, or a list of such for multiple kids}

\item{gap}{Gap arrows and points/rectangles}

\item{chrlength}{Length of chromosomes}

\item{cex}{Character expansion for x point}

\item{lwd}{Line width for points, segments, and arrows}

\item{arrow_length}{The \code{length} parameter in the call to
\code{\link[graphics:arrows]{graphics::arrows()}}}

\item{col}{Color of lines and points}

\item{...}{Additional arguments passed to arrows() and segments()}
}
\value{
None.
}
\description{
Add lines for a cross
}
\examples{
\dontshow{set.seed(67452378)}
mom <- create_parent(100, 1:2)
dad <- create_parent(100, 3:4)
kids <- lapply(1:4, function(junk) cross(mom, dad))
plot(0,0, type="n", xlim=c(0, 100), ylim=c(0,100),
     xaxt="n", yaxt="n", xlab="", ylab="")
loc <- list(c(25,75), c(75,75), c(12.5,25), c(37.5,25), c(62.5, 25), c(87.5,25))
plot_ind(mom, loc[[1]])
plot_ind(dad, loc[[2]])
for(i in 1:4) plot_ind(kids[[i]], loc[[i+2]])
plot_crosslines(loc[[1]], loc[[2]], loc[3:6])
}
\seealso{
\code{\link[=plot_ind]{plot_ind()}}
}
\keyword{hplot}
