% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ril_pedigree.R
\name{sim_ril_pedigree}
\alias{sim_ril_pedigree}
\title{Generate a ril pedigree}
\usage{
sim_ril_pedigree(
  ngen = 20,
  selfing = FALSE,
  parents = 1:2,
  firstind = max(parents) + 1
)
}
\arguments{
\item{ngen}{Number of generations of inbreeding}

\item{selfing}{If TRUE, use selfing}

\item{parents}{Vector of the parents' IDs. Should be integers, and
length must be a power of 2 (i.e., 2, 4, 8, ...)}

\item{firstind}{Positive integer to assign to the first child. Must
be greater than \code{max(parents)}.}
}
\value{
A data frame with five columns: individual ID, mother ID,
father ID, sex, and generation.  Founders have \code{0} for mother
and father ID. Sex is coded 0 for female and 1 for male.
}
\description{
Generate a pedigree for multi-way recombinant inbred lines (a table
of individual, mom, dad, sex)
}
\examples{
tab <- sim_ril_pedigree(7)
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}}, \code{\link[=sim_do_pedigree]{sim_do_pedigree()}},
\code{\link[=sim_4way_pedigree]{sim_4way_pedigree()}}
}
\keyword{datagen}
