% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_functions.R
\name{pred.fit}
\alias{pred.fit}
\title{Fit Simulated Data to a Model.}
\usage{
pred.fit(model, xpred = NULL, ci = 0.95, npoints = "same")
}
\arguments{
\item{model}{a model object, from (eg) lm}

\item{xpred}{the predictor for the x axis on the graph}

\item{ci}{confidence interval for fit curve (defaults
to 0.95)}

\item{npoints}{number of data points for fit line. Either specify
a number, or "same" will return a simulation of the same size
as the original dataset.}
}
\value{
predicted data
}
\description{
Fit Simulated Data to a Model.
}
\examples{
## Anwar M, Green JA, Norris P, et al 
## Prospective daily diary study reporting of any and all symptoms in healthy 
## adults in Pakistan: prevalence and #' response
## BMJ Open 2017;7:e014998
\donttest{data(symptom)
glm.symptom <- glm(actual_help_days ~ symp_days_reported, 
     family = "poisson", data = symptom)
pred.fit(glm.symptom)}

}
